
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega128
;Program type             : Application
;Clock frequency          : 16.000000 MHz
;Memory model             : Small
;Optimize for             : Speed
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 1024 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega128
	#pragma AVRPART MEMORY PROG_FLASH 131072
	#pragma AVRPART MEMORY EEPROM 4096
	#pragma AVRPART MEMORY INT_SRAM SIZE 4351
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	#define CALL_SUPPORTED 1

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU RAMPZ=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x6D
	.EQU XMCRB=0x6C

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0100
	.EQU __SRAM_END=0x10FF
	.EQU __DSTACK_SIZE=0x0400
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _flag_cnt=R5
	.DEF _key_input=R4
	.DEF _move_motion=R7

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	JMP  __RESET
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  _timer0_ovf_isr
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00
	JMP  0x00

_string:
	.DB  0x0,0x0,0x0,0x18,0xFE,0x18,0x80,0x19
	.DB  0x80,0x19,0x80,0x19,0x80,0x79,0x80,0x19
	.DB  0xC0,0x18,0xC0,0x18,0x60,0x18,0x38,0x18
	.DB  0xE,0x18,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0x6,0x18,0x6,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x78,0x6,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x18,0x6,0x18
	.DB  0xFC,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFC,0x19,0x6,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x78,0x6,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x18,0x6,0x18
	.DB  0xFC,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFE,0x18,0x80,0x19
	.DB  0x80,0x19,0x80,0x19,0x80,0x79,0xFC,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x18,0x6,0x18
	.DB  0xFC,0x1F,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFE,0x19,0x86,0x19
	.DB  0x86,0x19,0x86,0x19,0x86,0x79,0x86,0x19
	.DB  0x86,0x19,0x86,0x19,0x86,0x19,0x86,0x19
	.DB  0xFE,0x19,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0x86,0x19,0x86,0x19
	.DB  0x86,0x19,0x86,0x19,0xFE,0x79,0x86,0x19
	.DB  0x86,0x19,0x86,0x19,0x86,0x19,0x86,0x19
	.DB  0xFC,0x18,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0x60,0x18,0x60,0x18
	.DB  0x60,0x18,0x60,0x18,0x60,0x78,0xF0,0x18
	.DB  0xF0,0x18,0x98,0x19,0x98,0x19,0xC,0x1B
	.DB  0x6,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0x78,0x18,0xCC,0x18
	.DB  0x86,0x19,0x86,0x19,0x86,0x79,0x86,0x19
	.DB  0x86,0x19,0x86,0x19,0x86,0x19,0xCC,0x18
	.DB  0x78,0x18,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFC,0x1B,0x60,0x18
	.DB  0x60,0x18,0x60,0x18,0x70,0x78,0xF0,0x18
	.DB  0xF0,0x18,0x98,0x19,0x98,0x19,0xC,0x1B
	.DB  0x6,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xF8,0x19,0x0,0x18
	.DB  0xFC,0x1B,0x60,0x18,0x60,0x78,0x70,0x18
	.DB  0xF0,0x18,0x98,0x19,0x98,0x19,0xC,0x1B
	.DB  0x6,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFC,0x18,0x80,0x19
	.DB  0x80,0x19,0x80,0x19,0xFE,0x79,0x80,0x19
	.DB  0xC0,0x18,0xC0,0x18,0x60,0x18,0x38,0x18
	.DB  0xE,0x18,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFC,0x19,0x6,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x78,0xFE,0x18
	.DB  0x6,0x18,0x6,0x18,0x6,0x18,0x6,0x18
	.DB  0xFC,0x1F,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xFE,0x19,0x0,0x18
	.DB  0xCC,0x18,0xCC,0x18,0xCC,0x78,0xCC,0x18
	.DB  0xCC,0x18,0xCC,0x18,0xCC,0x18,0x78,0x18
	.DB  0xFE,0x1B,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x18,0xF8,0x18,0x0,0x18
	.DB  0xFE,0x1B,0x0,0x18,0xF8,0x78,0x8C,0x19
	.DB  0x8C,0x19,0x8C,0x19,0x8C,0x19,0x8C,0x19
	.DB  0xF8,0x18,0x0,0x18,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x3,0x80,0x3
	.DB  0xC0,0x6,0xC0,0x6,0xC0,0x6,0x60,0xC
	.DB  0x60,0xC,0xE0,0xF,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0x7,0x30,0xC
	.DB  0x30,0xC,0x30,0xC,0x30,0x6,0xF0,0x7
	.DB  0x30,0xC,0x30,0x18,0x30,0x18,0x30,0xC
	.DB  0xF0,0x7,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x7,0x60,0xC
	.DB  0x30,0x18,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x18,0x60,0xC
	.DB  0xC0,0x7,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0x3,0x30,0x6
	.DB  0x30,0xC,0x30,0x18,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x30,0x18,0x30,0xC,0x30,0x6
	.DB  0xF0,0x3,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0xF,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0xF0,0x7
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0xF0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0xF,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0xF0,0x7
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0xF,0xC0,0x18
	.DB  0x60,0x30,0x30,0x0,0x30,0x0,0x30,0x3E
	.DB  0x30,0x30,0x30,0x30,0x60,0x30,0xC0,0x38
	.DB  0x80,0x3F,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x30,0x18,0x30,0x18,0xF0,0x1F
	.DB  0x30,0x18,0x30,0x18,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x98,0x1,0x98,0x1
	.DB  0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0xC,0x30,0x6
	.DB  0x30,0x3,0xB0,0x1,0xF0,0x0,0xF0,0x1
	.DB  0x30,0x3,0x30,0x3,0x30,0x6,0x30,0xC
	.DB  0x30,0xC,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0xF0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x18,0x30,0x18,0x30
	.DB  0x38,0x38,0x38,0x38,0x78,0x3C,0x78,0x3C
	.DB  0xD8,0x36,0xD8,0x36,0x98,0x33,0x98,0x33
	.DB  0x18,0x30,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0xC,0x70,0xC
	.DB  0x70,0xC,0xF0,0xC,0xF0,0xC,0xB0,0xD
	.DB  0xB0,0xD,0x30,0xF,0x30,0xF,0x30,0xE
	.DB  0x30,0xE,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x7,0x60,0xC
	.DB  0x30,0x18,0x18,0x30,0x18,0x30,0x18,0x30
	.DB  0x18,0x30,0x18,0x30,0x30,0x18,0x60,0xC
	.DB  0xC0,0x7,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0x7,0x30,0xC
	.DB  0x30,0x18,0x30,0x18,0x30,0xC,0xF0,0x7
	.DB  0x30,0x0,0x30,0x0,0x30,0x0,0x30,0x0
	.DB  0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x7,0x60,0xC
	.DB  0x30,0x18,0x18,0x30,0x18,0x30,0x18,0x30
	.DB  0x18,0x30,0x18,0x33,0x30,0x1E,0x60,0xC
	.DB  0xC0,0x1F,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0x7,0x30,0xC
	.DB  0x30,0x18,0x30,0x18,0x30,0xC,0xF0,0x7
	.DB  0x30,0xC,0x30,0x18,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xC0,0x7,0x60,0xC
	.DB  0x30,0x18,0x30,0x0,0xE0,0x0,0x80,0x7
	.DB  0x0,0xC,0x0,0x18,0x30,0x18,0x60,0xC
	.DB  0xC0,0x7,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0xF,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x30,0x18,0x30,0x18,0x30,0x18
	.DB  0x30,0x18,0x30,0x18,0x30,0x18,0x60,0xC
	.DB  0xC0,0x7,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0xC,0x30,0xC
	.DB  0x30,0xC,0x60,0x6,0x60,0x6,0x60,0x6
	.DB  0xC0,0x3,0xC0,0x3,0xC0,0x3,0x80,0x1
	.DB  0x80,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x86,0x61,0x86,0x61
	.DB  0x86,0x61,0xCC,0x33,0xCC,0x33,0xCC,0x33
	.DB  0x78,0x1E,0x78,0x1E,0x78,0x1E,0x30,0xC
	.DB  0x30,0xC,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0xC,0x30,0xC
	.DB  0x60,0x6,0x60,0x6,0xC0,0x3,0x80,0x1
	.DB  0xC0,0x3,0x60,0x6,0x60,0x6,0x30,0xC
	.DB  0x30,0xC,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x30,0xC,0x30,0xC
	.DB  0x60,0x6,0x60,0x6,0xC0,0x3,0x80,0x1
	.DB  0x80,0x1,0x80,0x1,0x80,0x1,0x80,0x1
	.DB  0x80,0x1,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF0,0xF,0x0,0xC
	.DB  0x0,0x6,0x0,0x3,0x0,0x3,0x80,0x1
	.DB  0xC0,0x0,0xC0,0x0,0x60,0x0,0x30,0x0
	.DB  0xF0,0xF,0x0,0x0,0x0,0x0,0x0,0x0
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x0000

_0x3:
	.DB  0xF
_0xC6:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
_0xD8:
	.DB  0x0,0x0,0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x01
	.DW  _Move_cnt
	.DW  _0x3*2

	.DW  0x04
	.DW  0x04
	.DW  _0xD8*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,LOW(__SRAM_START)
	LDI  R27,HIGH(__SRAM_START)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

	OUT  RAMPZ,R24

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x500

	.CSEG
;/*****************************************************
;Project : 16X16 ƮƮ Ȯ庸(LK-DOTM16)(ATmega128)
;Version :
;Date    : 2013-07-06
;Author  : Kyung Nam Lee
;Company : LKӺ
;Comments: ~, A~Z ڸ ϴ α׷̴.
;Chip type               : ATmega128
;Program type            : Application
;AVR Core Clock frequency: 16.000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 1024
;*****************************************************/
;
;#include <mega128.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#define A0  PORTD.0
;#define A1  PORTD.1
;#define A2  PORTD.2
;#define A3  PORTD.3
;#define Data_Red PORTD.4
;#define Data_Green PORTD.5
;#define Clk  PORTD.6
;#define LE PORTD.7
;#define OE PORTB.0
;flash unsigned int string[][16]={
;0x00,0x1800,0x18fe,0x1980,0x1980,0x1980,0x7980,0x1980,0x18c0,0x18c0,0x1860,0x1838,0x180e,0x1800,0x00,0x00, //
;0x00,0x1800,0x1806,0x1806,0x1806,0x1806,0x7806,0x1806,0x1806,0x1806,0x1806,0x1806,0x1bfc,0x1800,0x00,0x00, //
;0x00,0x1800,0x19fc,0x1806,0x1806,0x1806,0x7806,0x1806,0x1806,0x1806,0x1806,0x1806,0x1bfc,0x1800,0x00,0x00, //
;0x00,0x1800,0x18fe,0x1980,0x1980,0x1980,0x7980,0x18fc,0x1806,0x1806,0x1806,0x1806,0x1ffc,0x1800,0x00,0x00, //
;0x00,0x1800,0x19fe,0x1986,0x1986,0x1986,0x7986,0x1986,0x1986,0x1986,0x1986,0x1986,0x19fe,0x1800,0x00,0x00, //
;0x00,0x1800,0x1986,0x1986,0x1986,0x1986,0x79fe,0x1986,0x1986,0x1986,0x1986,0x1986,0x18fc,0x1800,0x00,0x00, //
;0x00,0x1800,0x1860,0x1860,0x1860,0x1860,0x7860,0x18f0,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
;0x00,0x1800,0x1878,0x18cc,0x1986,0x1986,0x7986,0x1986,0x1986,0x1986,0x1986,0x18cc,0x1878,0x1800,0x00,0x00, //
;0x00,0x1800,0x1bfc,0x1860,0x1860,0x1860,0x7870,0x18f0,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
;0x00,0x1800,0x19f8,0x1800,0x1bfc,0x1860,0x7860,0x1870,0x18f0,0x1998,0x1998,0x1b0c,0x1b06,0x1800,0x00,0x00, //
;0x00,0x1800,0x18fc,0x1980,0x1980,0x1980,0x79fe,0x1980,0x18c0,0x18c0,0x1860,0x1838,0x180e,0x1800,0x00,0x00, //ī
;0x00,0x1800,0x19fc,0x1806,0x1806,0x1806,0x7806,0x18fe,0x1806,0x1806,0x1806,0x1806,0x1ffc,0x1800,0x00,0x00, //Ÿ
;0x00,0x1800,0x19fe,0x1800,0x18cc,0x18cc,0x78cc,0x18cc,0x18cc,0x18cc,0x18cc,0x1878,0x1bfe,0x1800,0x00,0x00, //
;0x00,0x1800,0x18f8,0x1800,0x1bfe,0x1800,0x78f8,0x198c,0x198c,0x198c,0x198c,0x198c,0x18f8,0x1800,0x00,0x00, //
;0x00,0x00,0x380,0x380,0x6c0,0x6c0,0x6c0,0xc60,0xc60,0xfe0,0x1830,0x1830,0x1830,0x00,0x00,0x00, //A
;0x00,0x00,0x7f0,0xc30,0xc30,0xc30,0x630,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0x00,0x00,0x00, //B
;0x00,0x00,0x7c0,0xc60,0x1830,0x30,0x30,0x30,0x30,0x30,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //C
;0x00,0x00,0x3f0,0x630,0xc30,0x1830,0x1830,0x1830,0x1830,0x1830,0xc30,0x630,0x3f0,0x00,0x00,0x00, //D
;0x00,0x00,0xff0,0x30,0x30,0x30,0x30,0x7f0,0x30,0x30,0x30,0x30,0xff0,0x00,0x00,0x00, //E
;0x00,0x00,0xff0,0x30,0x30,0x30,0x30,0x7f0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //F
;0x00,0x00,0xf80,0x18c0,0x3060,0x30,0x30,0x3e30,0x3030,0x3030,0x3060,0x38c0,0x3f80,0x00,0x00,0x00, //G
;0x00,0x00,0x1830,0x1830,0x1830,0x1830,0x1830,0x1ff0,0x1830,0x1830,0x1830,0x1830,0x1830,0x00,0x00,0x00, //H
;0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //I
;0x00,0x00,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x198,0x198,0xf0,0x00,0x00,0x00, //J
;0x00,0x00,0xc30,0x630,0x330,0x1b0,0xf0,0x1f0,0x330,0x330,0x630,0xc30,0xc30,0x00,0x00,0x00, //K
;0x00,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xff0,0x00,0x00,0x00, //L
;0x00,0x00,0x3018,0x3018,0x3838,0x3838,0x3c78,0x3c78,0x36d8,0x36d8,0x3398,0x3398,0x3018,0x00,0x00,0x00, //M
;0x00,0x00,0xc30,0xc70,0xc70,0xcf0,0xcf0,0xdb0,0xdb0,0xf30,0xf30,0xe30,0xe30,0x00,0x00,0x00, //N
;0x00,0x00,0x7c0,0xc60,0x1830,0x3018,0x3018,0x3018,0x3018,0x3018,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //O
;0x00,0x00,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00, //P
;0x00,0x00,0x7c0,0xc60,0x1830,0x3018,0x3018,0x3018,0x3018,0x3318,0x1e30,0xc60,0x1fc0,0x00,0x00,0x00, //Q
;0x00,0x00,0x7f0,0xc30,0x1830,0x1830,0xc30,0x7f0,0xc30,0x1830,0x1830,0x1830,0x1830,0x00,0x00,0x00, //R
;0x00,0x00,0x7c0,0xc60,0x1830,0x30,0xe0,0x780,0xc00,0x1800,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //S
;0x00,0x00,0xff0,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x180,0x00,0x00,0x00, //T
;0x00,0x00,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0x1830,0xc60,0x7c0,0x00,0x00,0x00, //U
;0x00,0x00,0xc30,0xc30,0xc30,0x660,0x660,0x660,0x3c0,0x3c0,0x3c0,0x180,0x180,0x00,0x00,0x00, //V
;0x00,0x00,0x6186,0x6186,0x6186,0x33cc,0x33cc,0x33cc,0x1e78,0x1e78,0x1e78,0xc30,0xc30,0x00,0x00,0x00, //W
;0x00,0x00,0xc30,0xc30,0x660,0x660,0x3c0,0x180,0x3c0,0x660,0x660,0xc30,0xc30,0x00,0x00,0x00, //X
;0x00,0x00,0xc30,0xc30,0x660,0x660,0x3c0,0x180,0x180,0x180,0x180,0x180,0x180,0x00,0x00,0x00, //Y
;0x00,0x00,0xff0,0xc00,0x600,0x300,0x300,0x180,0xc0,0xc0,0x60,0x30,0xff0,0x00,0x00,0x00, //Z
;};
;// Timer 0 overflow interrupt service routine
;unsigned char flag_cnt=0;
;#include <stdio.h>
;volatile unsigned int Move_cnt=15;

	.DSEG
;volatile unsigned int Move_cnt2=0;
;unsigned char key_input=0;
;volatile unsigned int up_cnt=0;
;#define string_stop_time_value 2000
;#define string_moving_speed_value 50
;
;#define up_down 1
;#define left_right 2
;
;static unsigned int str_speed_cnt=0;
;
;unsigned char move_motion=0;
;
;bit toggle_char=0;
;bit toggle_flag=0;
;#define in1 0
;#define in2 1  //  ƮƮ 1 ƮƮ 2 ģ.
;#define in3 2
;#define in4 3
;#define in5 4
;#define in6 5
;#define in7 6
;static unsigned int Dot_char_cnt=0; //ƮƮ ǥ   ī!
;//Timer 0 overflow interrupt service routine
;interrupt [TIM0_OVF] void timer0_ovf_isr(void)
; 0000 0062 {

	.CSEG
_timer0_ovf_isr:
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0063     static unsigned int toggle_cnt=0;
; 0000 0064     static unsigned int cnt=0;
; 0000 0065     cnt++;
	LDI  R26,LOW(_cnt_S0000000000)
	LDI  R27,HIGH(_cnt_S0000000000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 0066     if(cnt==500)
	LDS  R26,_cnt_S0000000000
	LDS  R27,_cnt_S0000000000+1
	CPI  R26,LOW(0x1F4)
	LDI  R30,HIGH(0x1F4)
	CPC  R27,R30
	BRNE _0x4
; 0000 0067     {
; 0000 0068     cnt=0;
	LDI  R30,LOW(0)
	STS  _cnt_S0000000000,R30
	STS  _cnt_S0000000000+1,R30
; 0000 0069     }
; 0000 006A     if(toggle_char){
_0x4:
	SBRS R2,0
	RJMP _0x5
; 0000 006B      toggle_cnt++;
	LDI  R26,LOW(_toggle_cnt_S0000000000)
	LDI  R27,HIGH(_toggle_cnt_S0000000000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 006C      if(toggle_cnt>1000)
	LDS  R26,_toggle_cnt_S0000000000
	LDS  R27,_toggle_cnt_S0000000000+1
	CPI  R26,LOW(0x3E9)
	LDI  R30,HIGH(0x3E9)
	CPC  R27,R30
	BRLO _0x6
; 0000 006D      {
; 0000 006E         toggle_char=0;
	CLT
	BLD  R2,0
; 0000 006F         toggle_cnt=0;
	LDI  R30,LOW(0)
	STS  _toggle_cnt_S0000000000,R30
	STS  _toggle_cnt_S0000000000+1,R30
; 0000 0070         toggle_flag^=1;
	LDI  R26,0
	SBRC R2,1
	LDI  R26,1
	LDI  R30,LOW(1)
	EOR  R30,R26
	CALL __BSTB1
	BLD  R2,1
; 0000 0071         move_motion=0;
	CLR  R7
; 0000 0072 
; 0000 0073         }
; 0000 0074      }
_0x6:
; 0000 0075      key_input=PINC&0x0f;
_0x5:
	IN   R30,0x13
	ANDI R30,LOW(0xF)
	MOV  R4,R30
; 0000 0076      str_speed_cnt++;
	LDI  R26,LOW(_str_speed_cnt_G000)
	LDI  R27,HIGH(_str_speed_cnt_G000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 0077     if(str_speed_cnt>string_moving_speed_value) //ڰ 500 ӹ  Ʈ !
	LDS  R26,_str_speed_cnt_G000
	LDS  R27,_str_speed_cnt_G000+1
	SBIW R26,51
	BRSH PC+3
	JMP _0x7
; 0000 0078     {
; 0000 0079 
; 0000 007A         str_speed_cnt=0; //string moving speed counter
	LDI  R30,LOW(0)
	STS  _str_speed_cnt_G000,R30
	STS  _str_speed_cnt_G000+1,R30
; 0000 007B         Move_cnt--;
	LDI  R26,LOW(_Move_cnt)
	LDI  R27,HIGH(_Move_cnt)
	LD   R30,X+
	LD   R31,X+
	SBIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 007C         Move_cnt2++;
	LDI  R26,LOW(_Move_cnt2)
	LDI  R27,HIGH(_Move_cnt2)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 007D         up_cnt++; // Ʒ ̵ ӵ īƮ
	LDI  R26,LOW(_up_cnt)
	LDI  R27,HIGH(_up_cnt)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 007E     if(Move_cnt==0||Move_cnt2==15)
	LDS  R26,_Move_cnt
	LDS  R27,_Move_cnt+1
	SBIW R26,0
	BREQ _0x9
	LDS  R26,_Move_cnt2
	LDS  R27,_Move_cnt2+1
	SBIW R26,15
	BRNE _0x8
_0x9:
; 0000 007F     {
; 0000 0080         Move_cnt2=0;
	LDI  R30,LOW(0)
	STS  _Move_cnt2,R30
	STS  _Move_cnt2+1,R30
; 0000 0081         Move_cnt=15;
	LDI  R30,LOW(15)
	LDI  R31,HIGH(15)
	STS  _Move_cnt,R30
	STS  _Move_cnt+1,R31
; 0000 0082         move_motion++; //   
	INC  R7
; 0000 0083         if(move_motion==2)
	LDI  R30,LOW(2)
	CP   R30,R7
	BRNE _0xB
; 0000 0084         {
; 0000 0085         move_motion=0;
	CLR  R7
; 0000 0086         Dot_char_cnt++;
	LDI  R26,LOW(_Dot_char_cnt_G000)
	LDI  R27,HIGH(_Dot_char_cnt_G000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 0087         flag_cnt++;
	INC  R5
; 0000 0088         if(flag_cnt==3)
	LDI  R30,LOW(3)
	CP   R30,R5
	BRNE _0xC
; 0000 0089         {
; 0000 008A         flag_cnt=0;
	CLR  R5
; 0000 008B         }
; 0000 008C         }
_0xC:
; 0000 008D     }
_0xB:
; 0000 008E 
; 0000 008F     }
_0x8:
; 0000 0090     TCNT0|=0x06;
_0x7:
	IN   R30,0x32
	ORI  R30,LOW(0x6)
	OUT  0x32,R30
; 0000 0091 }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	RETI
;void row_dynamic()
; 0000 0093 {
_row_dynamic:
; 0000 0094     static unsigned int str_cnt=0;
; 0000 0095 
; 0000 0096         switch(str_cnt)//ROW SHIFT!
	LDS  R30,_str_cnt_S0000001000
	LDS  R31,_str_cnt_S0000001000+1
; 0000 0097         {
; 0000 0098         case 0:A0=0; A1=0; A2=0; A3=0;break;
	SBIW R30,0
	BRNE _0x10
	CBI  0x12,0
	CBI  0x12,1
	CBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 0099         case 1:A0=1; A1=0; A2=0; A3=0; break;
_0x10:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x19
	SBI  0x12,0
	CBI  0x12,1
	CBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009A         case 2:A0=0; A1=1; A2=0; A3=0; break;
_0x19:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0x22
	CBI  0x12,0
	SBI  0x12,1
	CBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009B         case 3:A0=1; A1=1; A2=0; A3=0; break;
_0x22:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0x2B
	SBI  0x12,0
	SBI  0x12,1
	CBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009C         case 4:A0=0; A1=0; A2=1; A3=0; break;
_0x2B:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x34
	CBI  0x12,0
	CBI  0x12,1
	SBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009D         case 5:A0=1; A1=0; A2=1; A3=0; break;
_0x34:
	CPI  R30,LOW(0x5)
	LDI  R26,HIGH(0x5)
	CPC  R31,R26
	BRNE _0x3D
	SBI  0x12,0
	CBI  0x12,1
	SBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009E         case 6:A0=0; A1=1; A2=1; A3=0; break;
_0x3D:
	CPI  R30,LOW(0x6)
	LDI  R26,HIGH(0x6)
	CPC  R31,R26
	BRNE _0x46
	CBI  0x12,0
	SBI  0x12,1
	SBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 009F         case 7:A0=1; A1=1; A2=1; A3=0; break;
_0x46:
	CPI  R30,LOW(0x7)
	LDI  R26,HIGH(0x7)
	CPC  R31,R26
	BRNE _0x4F
	SBI  0x12,0
	SBI  0x12,1
	SBI  0x12,2
	CBI  0x12,3
	RJMP _0xF
; 0000 00A0         case 8:A0=0; A1=0; A2=0; A3=1; break;
_0x4F:
	CPI  R30,LOW(0x8)
	LDI  R26,HIGH(0x8)
	CPC  R31,R26
	BRNE _0x58
	CBI  0x12,0
	CBI  0x12,1
	CBI  0x12,2
	RJMP _0xD4
; 0000 00A1         case 9:A0=1; A1=0; A2=0; A3=1; break;
_0x58:
	CPI  R30,LOW(0x9)
	LDI  R26,HIGH(0x9)
	CPC  R31,R26
	BRNE _0x61
	SBI  0x12,0
	CBI  0x12,1
	CBI  0x12,2
	RJMP _0xD4
; 0000 00A2         case 10:A0=0; A1=1; A2=0; A3=1; break;
_0x61:
	CPI  R30,LOW(0xA)
	LDI  R26,HIGH(0xA)
	CPC  R31,R26
	BRNE _0x6A
	CBI  0x12,0
	SBI  0x12,1
	CBI  0x12,2
	RJMP _0xD4
; 0000 00A3         case 11:A0=1; A1=1; A2=0; A3=1; break;
_0x6A:
	CPI  R30,LOW(0xB)
	LDI  R26,HIGH(0xB)
	CPC  R31,R26
	BRNE _0x73
	SBI  0x12,0
	SBI  0x12,1
	CBI  0x12,2
	RJMP _0xD4
; 0000 00A4         case 12:A0=0; A1=0; A2=1; A3=1; break;
_0x73:
	CPI  R30,LOW(0xC)
	LDI  R26,HIGH(0xC)
	CPC  R31,R26
	BRNE _0x7C
	CBI  0x12,0
	CBI  0x12,1
	RJMP _0xD5
; 0000 00A5         case 13:A0=1; A1=0; A2=1; A3=1; break;
_0x7C:
	CPI  R30,LOW(0xD)
	LDI  R26,HIGH(0xD)
	CPC  R31,R26
	BRNE _0x85
	SBI  0x12,0
	CBI  0x12,1
	RJMP _0xD5
; 0000 00A6         case 14:A0=0; A1=1; A2=1; A3=1; break;
_0x85:
	CPI  R30,LOW(0xE)
	LDI  R26,HIGH(0xE)
	CPC  R31,R26
	BRNE _0x8E
	CBI  0x12,0
	RJMP _0xD6
; 0000 00A7         case 15:A0=1; A1=1; A2=1; A3=1; break;
_0x8E:
	CPI  R30,LOW(0xF)
	LDI  R26,HIGH(0xF)
	CPC  R31,R26
	BRNE _0xF
	SBI  0x12,0
_0xD6:
	SBI  0x12,1
_0xD5:
	SBI  0x12,2
_0xD4:
	SBI  0x12,3
; 0000 00A8         }
_0xF:
; 0000 00A9 
; 0000 00AA     ++str_cnt;
	LDI  R26,LOW(_str_cnt_S0000001000)
	LDI  R27,HIGH(_str_cnt_S0000001000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 00AB     if(str_cnt==16)
	LDS  R26,_str_cnt_S0000001000
	LDS  R27,_str_cnt_S0000001000+1
	SBIW R26,16
	BRNE _0xA0
; 0000 00AC     {
; 0000 00AD     str_cnt=0;
	LDI  R30,LOW(0)
	STS  _str_cnt_S0000001000,R30
	STS  _str_cnt_S0000001000+1,R30
; 0000 00AE     }
; 0000 00AF }
_0xA0:
	RET
;void shift_Driver(unsigned char out)
; 0000 00B1 {
_shift_Driver:
; 0000 00B2 
; 0000 00B3     unsigned char clk=0;
; 0000 00B4     for(clk=0;clk<8;clk++){ //8Ʈ ͸ 1Ʈ ƮͿ Է
	ST   -Y,R17
;	out -> Y+1
;	clk -> R17
	LDI  R17,0
	LDI  R17,LOW(0)
_0xA2:
	CPI  R17,8
	BRSH _0xA3
; 0000 00B5 		if(out&(0x80>>clk))
	MOV  R30,R17
	LDI  R26,LOW(128)
	CALL __LSRB12
	LDD  R26,Y+1
	AND  R30,R26
	BREQ _0xA4
; 0000 00B6 		{
; 0000 00B7         switch(flag_cnt) { // LED  !
	MOV  R30,R5
	LDI  R31,0
; 0000 00B8         case 0:Data_Green=0;Data_Red=1; break;
	SBIW R30,0
	BRNE _0xA8
	CBI  0x12,5
	RJMP _0xD7
; 0000 00B9         case 1:Data_Green=1;Data_Red=0; break;
_0xA8:
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0xAD
	SBI  0x12,5
	CBI  0x12,4
	RJMP _0xA7
; 0000 00BA         case 2:Data_Green=1;Data_Red=1; break;
_0xAD:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0xA7
	SBI  0x12,5
_0xD7:
	SBI  0x12,4
; 0000 00BB         }
_0xA7:
; 0000 00BC 		}
; 0000 00BD         else {
	RJMP _0xB7
_0xA4:
; 0000 00BE          Data_Green=0;
	CBI  0x12,5
; 0000 00BF          Data_Red=0;
	CBI  0x12,4
; 0000 00C0         }
_0xB7:
; 0000 00C1         Clk=1;delay_us(1);Clk=0;
	SBI  0x12,6
	__DELAY_USB 5
	CBI  0x12,6
; 0000 00C2     }
	SUBI R17,-1
	RJMP _0xA2
_0xA3:
; 0000 00C3 }
	LDD  R17,Y+0
	ADIW R28,2
	RET
;
;void ActivePulse()
; 0000 00C6 {
_ActivePulse:
; 0000 00C7     LE=1; delay_us(1); LE=0;// ġ 
	SBI  0x12,7
	__DELAY_USB 5
	CBI  0x12,7
; 0000 00C8     OE=0;
	CBI  0x18,0
; 0000 00C9     delay_us(500); // OUTPUT ENABLE
	__DELAY_USW 2000
; 0000 00CA }
	RET
;
;void dot1_display_shift(unsigned int first)
; 0000 00CD {
_dot1_display_shift:
; 0000 00CE             static unsigned int i_cnt=0;
; 0000 00CF             register unsigned int buff[16]={0};
; 0000 00D0             register unsigned char high=0;
; 0000 00D1             register unsigned char low=0;
; 0000 00D2             register unsigned int i=0;
; 0000 00D3                 for(i_cnt=0;i_cnt<16;i_cnt++){ //ڰ ʿ ߾, ߾ӿ   귯 ǥ
	SBIW R28,32
	LDI  R24,32
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0xC6*2)
	LDI  R31,HIGH(_0xC6*2)
	CALL __INITLOCB
	CALL __SAVELOCR4
;	first -> Y+36
;	buff -> Y+4
;	high -> R17
;	low -> R16
;	i -> R18,R19
	LDI  R17,0
	LDI  R16,0
	__GETWRN 18,19,0
	LDI  R30,LOW(0)
	STS  _i_cnt_S0000004000,R30
	STS  _i_cnt_S0000004000+1,R30
_0xC8:
	LDS  R26,_i_cnt_S0000004000
	LDS  R27,_i_cnt_S0000004000+1
	SBIW R26,16
	BRLO PC+3
	JMP _0xC9
; 0000 00D4                     if(move_motion==in1)
	TST  R7
	BRNE _0xCA
; 0000 00D5                     {
; 0000 00D6                       buff[i_cnt]=string[first][i_cnt]<<Move_cnt; // 1st String Dot1 in
	LDS  R30,_i_cnt_S0000004000
	LDS  R31,_i_cnt_S0000004000+1
	MOVW R26,R28
	ADIW R26,4
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDD  R30,Y+36
	LDD  R31,Y+36+1
	LSL  R30
	ROL  R31
	CALL __LSLW4
	SUBI R30,LOW(-_string*2)
	SBCI R31,HIGH(-_string*2)
	MOVW R26,R30
	LDS  R30,_i_cnt_S0000004000
	LDS  R31,_i_cnt_S0000004000+1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW2PF
	LDS  R30,_Move_cnt
	CALL __LSLW12
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 0000 00D7                     }
; 0000 00D8                     if(move_motion==in2)
_0xCA:
	LDI  R30,LOW(1)
	CP   R30,R7
	BRNE _0xCB
; 0000 00D9                     {
; 0000 00DA 
; 0000 00DB                       buff[i_cnt]=string[first][i_cnt]>>Move_cnt2; // 1st String Dot1 Out
	LDS  R30,_i_cnt_S0000004000
	LDS  R31,_i_cnt_S0000004000+1
	MOVW R26,R28
	ADIW R26,4
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	MOVW R22,R30
	LDD  R30,Y+36
	LDD  R31,Y+36+1
	LSL  R30
	ROL  R31
	CALL __LSLW4
	SUBI R30,LOW(-_string*2)
	SBCI R31,HIGH(-_string*2)
	MOVW R26,R30
	LDS  R30,_i_cnt_S0000004000
	LDS  R31,_i_cnt_S0000004000+1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	CALL __GETW2PF
	LDS  R30,_Move_cnt2
	CALL __LSRW12
	MOVW R26,R22
	ST   X+,R30
	ST   X,R31
; 0000 00DC                     }
; 0000 00DD                 }
_0xCB:
	LDI  R26,LOW(_i_cnt_S0000004000)
	LDI  R27,HIGH(_i_cnt_S0000004000)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	RJMP _0xC8
_0xC9:
; 0000 00DE                 for(i=0;i<16;i++)
	__GETWRN 18,19,0
_0xCD:
	__CPWRN 18,19,16
	BRSH _0xCE
; 0000 00DF                 {
; 0000 00E0                 high=(buff[i]>>8);
	MOVW R30,R18
	MOVW R26,R28
	ADIW R26,4
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	MOV  R30,R31
	LDI  R31,0
	MOV  R17,R30
; 0000 00E1                 low =(buff[i]&0xff);
	MOVW R30,R18
	MOVW R26,R28
	ADIW R26,4
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	MOV  R16,R30
; 0000 00E2                 shift_Driver(high);
	ST   -Y,R17
	RCALL _shift_Driver
; 0000 00E3                 shift_Driver(low);
	ST   -Y,R16
	RCALL _shift_Driver
; 0000 00E4                 row_dynamic();
	RCALL _row_dynamic
; 0000 00E5                 ActivePulse();
	RCALL _ActivePulse
; 0000 00E6                 }
	__ADDWRN 18,19,1
	RJMP _0xCD
_0xCE:
; 0000 00E7 }
	CALL __LOADLOCR4
	ADIW R28,38
	RET
;void main(void)
; 0000 00E9 {
_main:
; 0000 00EA DDRD=0xff;
	LDI  R30,LOW(255)
	OUT  0x11,R30
; 0000 00EB DDRB=0x01;
	LDI  R30,LOW(1)
	OUT  0x17,R30
; 0000 00EC /*
; 0000 00ED  A0  PORTD.0
; 0000 00EE  A1  PORTD.1
; 0000 00EF  A2  PORTD.2
; 0000 00F0  A3  PORTD.3
; 0000 00F1  Data_Red PORTD.4
; 0000 00F2  Data_Green PORTD.5
; 0000 00F3  Clk  PORTD.6
; 0000 00F4  LE PORTD.7
; 0000 00F5  OE PORTB.0
; 0000 00F6 */
; 0000 00F7 
; 0000 00F8 TCCR0=0x04;
	LDI  R30,LOW(4)
	OUT  0x33,R30
; 0000 00F9 TCNT0=0x06;
	LDI  R30,LOW(6)
	OUT  0x32,R30
; 0000 00FA TIMSK=0x01;
	LDI  R30,LOW(1)
	OUT  0x37,R30
; 0000 00FB // Global enable interrupts
; 0000 00FC #asm("sei")
	sei
; 0000 00FD toggle_char=0;
	CLT
	BLD  R2,0
; 0000 00FE while(1)
_0xCF:
; 0000 00FF {
; 0000 0100  dot1_display_shift(Dot_char_cnt);
	LDS  R30,_Dot_char_cnt_G000
	LDS  R31,_Dot_char_cnt_G000+1
	ST   -Y,R31
	ST   -Y,R30
	RCALL _dot1_display_shift
; 0000 0101  if(Dot_char_cnt==40)
	LDS  R26,_Dot_char_cnt_G000
	LDS  R27,_Dot_char_cnt_G000+1
	SBIW R26,40
	BRNE _0xD2
; 0000 0102  Dot_char_cnt=0;
	LDI  R30,LOW(0)
	STS  _Dot_char_cnt_G000,R30
	STS  _Dot_char_cnt_G000+1,R30
; 0000 0103 }
_0xD2:
	RJMP _0xCF
; 0000 0104 }
_0xD3:
	RJMP _0xD3
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG

	.CSEG

	.CSEG

	.DSEG
_Move_cnt:
	.BYTE 0x2
_Move_cnt2:
	.BYTE 0x2
_up_cnt:
	.BYTE 0x2
_str_speed_cnt_G000:
	.BYTE 0x2
_Dot_char_cnt_G000:
	.BYTE 0x2
_toggle_cnt_S0000000000:
	.BYTE 0x2
_cnt_S0000000000:
	.BYTE 0x2
_str_cnt_S0000001000:
	.BYTE 0x2
_i_cnt_S0000004000:
	.BYTE 0x2

	.CSEG

	.CSEG
__LSRB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSRB12R
__LSRB12L:
	LSR  R30
	DEC  R0
	BRNE __LSRB12L
__LSRB12R:
	RET

__LSLW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSLW12R
__LSLW12L:
	LSL  R30
	ROL  R31
	DEC  R0
	BRNE __LSLW12L
__LSLW12R:
	RET

__LSRW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSRW12R
__LSRW12L:
	LSR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRW12L
__LSRW12R:
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETW2PF:
	LPM  R26,Z+
	LPM  R27,Z
	RET

__BSTB1:
	CLT
	TST  R30
	BREQ PC+2
	SET
	RET

__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__INITLOCB:
__INITLOCW:
	ADD  R26,R28
	ADC  R27,R29
__INITLOC0:
	LPM  R0,Z+
	ST   X+,R0
	DEC  R24
	BRNE __INITLOC0
	RET

;END OF CODE MARKER
__END_OF_CODE:
